/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.client;

import al132.alib.client.CapabilityDisplayWrapper;
import al132.alib.client.CapabilityEnergyDisplayWrapper;
import al132.alib.client.CapabilityFluidDisplayWrapper;
import al132.alib.container.ABaseContainer;
import al132.alib.tiles.GuiTile;
import al132.alib.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class ABaseScreen<T extends ABaseContainer>
extends AbstractContainerScreen<T> {
    protected ResourceLocation GUI;
    T screenContainer;
    protected final List<CapabilityDisplayWrapper> displayData = new ArrayList<CapabilityDisplayWrapper>();
    ResourceLocation powerBarTexture = new ResourceLocation("alib", "textures/gui/template.png");

    public ABaseScreen(String modid, T screenContainer, Inventory inv, Component name, String path) {
        super(screenContainer, inv, name);
        this.screenContainer = screenContainer;
        this.f_97726_ = ((GuiTile)((Object)((ABaseContainer)((Object)screenContainer)).tile)).getWidth();
        this.f_97727_ = ((GuiTile)((Object)((ABaseContainer)((Object)screenContainer)).tile)).getHeight();
        this.GUI = new ResourceLocation(modid, path);
    }

    protected void m_7286_(PoseStack ps, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(ps, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7027_(PoseStack ps, int mouseX, int mouseY) {
        String displayName = ((ABaseContainer)((Object)this.screenContainer)).tile.getDisplayName().getString();
        ABaseScreen.m_93236_((PoseStack)ps, (Font)this.f_96547_, (String)displayName, (int)(this.f_97726_ / 2 - this.f_96547_.m_92895_(displayName) / 2), (int)-10, (int)Color.WHITE.getRGB());
    }

    public void m_6305_(PoseStack ps, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ps);
        super.m_6305_(ps, mouseX, mouseY, partialTicks);
        this.m_7025_(ps, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.displayData.forEach(data -> {
            if (data instanceof CapabilityEnergyDisplayWrapper) {
                this.drawPowerBar(ps, (CapabilityEnergyDisplayWrapper)data, this.powerBarTexture, 0, 0);
            } else if (data instanceof CapabilityFluidDisplayWrapper) {
                this.drawFluidTank((CapabilityFluidDisplayWrapper)data, x + data.x, y + data.y);
            }
        });
        this.displayData.stream().filter(data -> mouseX >= data.x + x && mouseX <= data.x + x + data.width && mouseY >= data.y + y && mouseY <= data.y + y + data.height).forEach(it -> this.m_96602_(ps, it.toTextComponent(), mouseX, mouseY));
    }

    public int getBarScaled(int pixels, int count, int max) {
        if (count > 0 && max > 0) {
            return count * pixels / max;
        }
        return 0;
    }

    public void drawPowerBar(PoseStack ps, CapabilityEnergyDisplayWrapper data, ResourceLocation texture, int textureX, int textureY) {
        if (data.getStored() > 0) {
            int i = data.x + (this.f_96543_ - this.f_97726_) / 2;
            int j = data.y + (this.f_96544_ - this.f_97727_) / 2;
            int k = this.getBarScaled(data.height, data.getStored(), data.getCapacity());
            RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
            this.m_93228_(ps, i, j + data.height - k, textureX, textureY, data.width, k);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        }
    }

    public void drawFluidTank(CapabilityFluidDisplayWrapper wrapper, int i, int j) {
        this.drawFluidTank(wrapper, i, j, 16, 60);
    }

    public void drawFluidTank(CapabilityFluidDisplayWrapper wrapper, int i, int j, int width, int height) {
        if (wrapper.getStored() > 5) {
            RenderUtils.bindBlockTexture();
            RenderUtils.renderGuiTank(wrapper.getHandler().getFluidInTank(0), wrapper.getCapacity(), wrapper.getStored(), i, j, this.m_93252_(), width, height);
        }
    }

    public void bindWidgets() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("alib", "textures/gui/widgets.png"));
    }

    public void drawRightArrow(PoseStack ps, int x, int y, int width) {
        int height = 9;
        this.bindWidgets();
        this.m_93228_(ps, x, y, 0, 120, width, height);
    }

    public void drawDownArrow(PoseStack ps, int x, int y, int height) {
        int width = 9;
        this.bindWidgets();
        this.m_93228_(ps, x, y, 9, 129, width, height);
    }

    public void drawUpArrow(PoseStack ps, int x, int y, int height) {
        int width = 9;
        this.bindWidgets();
        this.m_93228_(ps, x, y, 0, 129, width, height);
    }
}

